/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.util;

import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class SwtUtil {
    private static TextBundle textBundle = UiBundle.getInstance();

    public static void center(Shell parent, Shell child) {
        int x = parent.getLocation().x + (parent.getSize().x - child.getSize().x) / 2;
        int y = parent.getLocation().y + (parent.getSize().y - child.getSize().y) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        child.setLocation(x, y);
    }

    public static void setupPagingInformation(ScrolledComposite composite) {
        GC gc = new GC(composite);
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int fontHeight = fontMetrics.getHeight();
        int fontWidth = fontMetrics.getAverageCharWidth();
        Rectangle clientArea = composite.getClientArea();
        int lines = clientArea.height / fontHeight;
        int pageHeight = lines * fontHeight;
        int pageWidth = clientArea.width - fontWidth;
        composite.getVerticalBar().setIncrement(fontHeight);
        composite.getVerticalBar().setPageIncrement(pageHeight);
        composite.getHorizontalBar().setIncrement(fontWidth);
        composite.getHorizontalBar().setPageIncrement(pageWidth);
    }

    public static Printer showPrintDialog(Control control) {
        PrintDialog dialog = new PrintDialog(control.getShell());
        PrinterData printerData = dialog.open();
        if (printerData == null) {
            return null;
        }
        return new Printer(printerData);
    }

    public static int showYesNoDialog(Shell shell, String title, String message) {
        MessageBox messageBox = new MessageBox(shell, 196);
        messageBox.setText(title);
        messageBox.setMessage(message);
        return messageBox.open();
    }

    public static int showOkCancelErrorDialog(Shell shell, String title, String message) {
        MessageBox messageBox = new MessageBox(shell, 289);
        messageBox.setText(title);
        messageBox.setMessage(message);
        return messageBox.open();
    }

    public static void showErrorDialog(Shell shell, String title, String message) {
        MessageBox messageBox = new MessageBox(shell, 33);
        messageBox.setText(title);
        messageBox.setMessage(message);
        messageBox.open();
    }

    public static void showSystemErrorDialog(Shell shell, Throwable throwable) {
        SwtUtil.showErrorDialog(shell, textBundle.get("SystemErrorTitle"), textBundle.format("SystemErrorMessage", throwable.getMessage()));
    }
}

